REM EoTGRAF5.BAS     (Local Apparent Time to Standard Time)
REM Mac Oglesby  980916  080525 (uses Fer's EoT algorithm)
PRINT
PRINT "     EoTGRAF5.BAS by Mac Oglesby  980916 rev. 080527"
PRINT
PRINT "This program creates a graph showing correction (in minutes)"
PRINT "to apply to Local Apparent Time (L.A.T.) to get Standard Time,"
PRINT "here considered as Local Mean Time corrected for longitudinal"
PRINT "offset. Graph is shown on the screen and written to a text file."
PRINT
PRINT "Use the utility CNVXXXX.EXE by Fer de Vries to convert the text"
PRINT "file to a dxf file, for importing into your CAD program."
REM  You MUST set filename$ to suit your situation
filename$ = "C:\basic\eotgraf.txt"     '[disk:] [path] filename.txt
10 PRINT : PRINT "Default output filename is   "; filename$: PRINT
INPUT "Use default filename?     1 = yes   2 = no ", xx3
IF xx3 = 1 THEN GOTO 20
IF xx3 <> 2 THEN GOTO 10
PRINT : INPUT "filename for output text    ", filename$
20 OPEN filename$ FOR OUTPUT AS #1: PRINT
REM  Set your local longitude and standard time zone meridian.
INPUT "Longitude of local meridian (decimal degrees, west +) ", LL
INPUT "Longitude of standard time zone meridian (decimal deg.) ", LS
REM  Note: it may be useful to declare a standard time zone meridian
REM  which is offset from one's actual time zone meridian.
'LL = 72.5  REM   Example of graph for daylight saving time for solar time
'LS = 60    REM   dial. This graph has positive numbers only.

LC = (LL - LS) * 4             'longitude offset in minutes
SN = SGN(LC)
ChG = INT(ABS(LC))      'whole minute changes to graph reference marks
ChG = ChG * SN
AjG = (ABS(ChG) - ABS(LC)) * SN   'adjust EoT graph for fractional minutes

DIM M$(13): DIM M(13)
FOR J = 1 TO 13
READ M$: M$(J) = M$
READ M: M(J) = M + 1.5   'day (noon UT) of year for 1st of month (Jan 1 = 1)
NEXT J

SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color
LINE (0, 0)-(640, 480), 1, BF      'Sets background white

REM  Certain helpful information is printed to screen (only).
LOCATE 1, 1: PRINT "Program listing has instructions."
LOCATE 1, 39: PRINT "Graph shows EoT plus longitude correction"
LOCATE 2, 1: PRINT "Std. Time Meridian = "; LS
LOCATE 3, 1: PRINT "Local Meridian = "; LL
LOCATE 2, 36: PRINT "Longitude Correction (min.): "; LC
LOCATE 5, 17: PRINT "Apply to Local Apparent Time for 'corrected' time"
'LOCATE 7, 10: PRINT "(+)"
LOCATE 15, 6: PRINT "(minutes)"
'LOCATE 22, 10: PRINT "(-)"
LOCATE 27, 16
FOR J = 1 TO 13: PRINT M$(J); " "; : NEXT J     'months on screen
LOCATE 29, 1: PRINT "filename$ = "; filename$;

WRITE #1, 9, 87, 0     'Axis lines, scale ticks in layer L_W

X0 = 140: Y0 = 220     'screen coordinates of origin for EoT curve

REM  On screen, origin (0,0) is at upper left corner, x is positive
REM  to the right, y is positive down.  CNVXXXX.EXE expects x pos-
REM  itive right, but y positive up.  So, the sign of y is reversed
REM  for y values written to the data file.

REM  You may want to shift the data points in the drawing relative
REM  to the origin.  This won't affect the screen plot.
REM  Use values to suit your needs.  Use ' to disable unwanted values.
'shX = -320: shY = -240   'origin shifted near drawing's center
shX = -X0: shY = -Y0   'origin shifted to drawing's origin
'shX = 0: shY = 0          'origin remains at upper left

REM  The drawing may be scaled up or down by changing scX and/or scY.
REM  Unless scX = scY, the drawing will be distorted, (which may be
REM  what is desired).  The screen plot isn't affected.
'scX = 1: scY = 1     'drawing scale opens at about 61
scX = .01475: scY = .01475     'drawing scale opens near 1
Vsc = 8   'vertical scale ("norm" is 10)

FOR J = -16 TO 18                  'line for each minute
L = 1.5
IF (-J + ChG) / 5 = INT((-J + ChG) / 5) THEN L = -2  'mark 5 min. lines
IF (-J + ChG) / 10 = INT((-J + ChG) / 10) THEN L = -5  'mark 10 min. lines
IF J = ChG THEN L = -8        'identify X-axis (0 minutes)
LINE (X0 + L, Y0 + Vsc * J)-(X0 + 366.5, Y0 + Vsc * J), 0
WRITE #1, 1, (X0 + L + shX) * scX, -(Y0 + Vsc * J + shY) * scY
WRITE #1, 2, (X0 + 366.5 + shX) * scX, -(Y0 + Vsc * J + shY) * scY
NEXT J
LOCATE 3, 36: PRINT "Top minute line is "; 16 + ChG; "  bottom "; ChG - 18


FOR K = 1 TO 13           'line for 1st day of each month
L1 = 180 * Vsc / 10: L2 = 160 * Vsc / 10
LINE (X0 + M(K), Y0 - L2)-(X0 + M(K), Y0 + L1 + 5), 0
WRITE #1, 1, (X0 + M(K) + shX) * scX, -(Y0 - L2 + shY) * scY
WRITE #1, 2, (X0 + M(K) + shX) * scX, -(Y0 + L1 + 5 + shY) * scY

IF K = 13 THEN 25
FOR K1 = 10 TO 20 STEP 10   'lines for 11th and 21st days of month
LINE (X0 + M(K) + K1, Y0 - L2)-(X0 + M(K) + K1, Y0 + L1), 0
WRITE #1, 1, (X0 + M(K) + K1 + shX) * scX, -(Y0 - L2 + shY) * scY
WRITE #1, 2, (X0 + M(K) + K1 + shX) * scX, -(Y0 + L1 + shY) * scY
NEXT K1
25 NEXT K

WRITE #1, 9, 88, 0      'Curve in layer L_X

flag = 1

PI# = 3.141592653#
D2R = PI# / 180   'convert degrees to radians
R2D = 180 / PI#   'convert radians to degrees

FOR N = 1 TO 366
REM  EoT is calculated for 1998 using a method published by Fer de Vries.
L8 = N * 360 / 365.2422 - 80.535132#     'degrees
E1 = -107.0605 * SIN(L8 * D2R) - 428.6697 * COS(L8 * D2R) + 596.1009 * SIN(2 * L8 * D2R)
E2 = -2.0898 * COS(2 * L8 * D2R) + 4.4173 * SIN(3 * L8 * D2R)
E3 = 19.2776 * COS(3 * L8 * D2R) - 12.7338 * SIN(4 * L8 * D2R)  'seconds of time
E = E1 + E2 + E3
E = E / 60       'EoT in minutes
X = N + X0 + .5
Y = (E + AjG) * Vsc + Y0
PSET (X, Y), 0           'plot points on screen
WRITE #1, flag, (X + shX) * scX, -(Y + shY) * scY  'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
NEXT N
CLOSE #1
DATA "JAN",0,"FEB",31,"MAR",59,"APR",90
DATA "MAY",120,"JUN",151,"JUL",181,"AUG",212
DATA "SEP",243,"OCT",273,"NOV",304,"DEC",334,"JAN",365
END


