REM EoTTBL05.BAS     (Local Apparent Time to Standard Time)
REM Mac Oglesby  980916  080527 (uses Fer's EoT algorithm)
PRINT
PRINT "     EoTTBL05.BAS by Mac Oglesby  980916 rev. 080527"
PRINT
PRINT "This program creates a table showing correction (in minutes)"
PRINT "to apply to Local Apparent Time (L.A.T.) to get Standard Time,"
PRINT "here considered as Local Mean Time corrected for longitudinal"
PRINT "offset. Values are shown on the screen and written to a text file."
REM  You MUST set filename$ to suit your situation
filename$ = "C:\basic\eottabl.txt"     '[disk:] [path] filename.txt
10 PRINT : PRINT "Default output filename is     "; filename$: PRINT
INPUT "Use default filename?    1 = yes   2 = no ", xx3
IF xx3 = 1 THEN GOTO 20
IF xx3 <> 2 THEN GOTO 10
PRINT : INPUT "filename for output text  ", filename$
20 OPEN filename$ FOR OUTPUT AS #1
REM  Set your local longitude and standard time zone meridian.
INPUT "Longitude of local meridian (decimal degrees, west +) ", LL
INPUT "Longitude of standard time zone meridian (decimal deg.) ", LS
'LL = 72.5  REM   Example of table for daylight saving time for solar time
'LS = 60    REM   dial. This table has positive numbers only.
LC = (LS - LL) * 4             'longitude offset in minutes
DIM M$(13): DIM M(13): DIM DISP$(11, 14)
FOR J = 1 TO 13
READ M$: M$(J) = M$
READ M: M(J) = M + 1.5   'day (noon UT) of year for 1st of month (Jan 1 = 1)
NEXT J
FOR J = 1 TO 10
READ x$: DISP$(J, 0) = x$ + " ": DISP$(J, 13) = "   " + x$
NEXT J
SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color
LINE (0, 0)-(640, 480), 1, BF      'Sets background white
LOCATE 2, 1: PRINT "Std. Time Meridian = "; LS
LOCATE 3, 1: PRINT "Local Meridian = "; LL
LOCATE 7, 5
FOR J = 1 TO 12: DISP$(0, J) = M$(J) + " ": NEXT J  'months
DISP$(0, 0) = "    "
LOCATE 3, 40: PRINT "filename$ = "; filename$;
D2R = 3.14159 / 180
FOR J1 = 1 TO 12: C8 = 0
FOR J2 = M(J1) TO M(J1 + 1) STEP 3
C8 = C8 + 1
REM  EoT is calculated for 1998 using adaptation of Fer de Vries' method.
L8 = J2 * 360 / 365.2422 - 80.535132#           'degrees
E1 = -107.0605 * SIN(L8 * D2R) - 428.6697 * COS(L8 * D2R)
E2 = 596.1009 * SIN(2 * L8 * D2R)
E3 = -2.0898 * COS(2 * L8 * D2R) + 4.4173 * SIN(3 * L8 * D2R)
E4 = 19.2776 * COS(3 * L8 * D2R) - 12.7338 * SIN(4 * L8 * D2R)  'secs of time
E = (E1 + E2 + E3 + E4) / 60     'EoT in minutes of time
TotCor = INT(E + LC + .5) * -1    'total correction to nearest minute
DISP$(C8, J1) = " " + STR$(TotCor)
IF ABS(TotCor) < 10 THEN DISP$(C8, J1) = " " + DISP$(C8, J1)
NEXT J2
NEXT J1
LOCATE 7, 1
FOR J = 0 TO 10
FOR K = 0 TO 13
PRINT DISP$(J, K);
PRINT #1, DISP$(J, K);
NEXT K
PRINT
PRINT #1,
NEXT J
CLOSE #1
DATA "JAN",0,"FEB",31,"MAR",59,"APR",90
DATA "MAY",120,"JUN",151,"JUL",181,"AUG",212
DATA "SEP",243,"OCT",273,"NOV",304,"DEC",334,"JAN",365
DATA " 1"," 4"," 7","10","13","16","19","22","25","28"
END


