
REM CD-BEAD4.BAS rev Mac Oglesby (2 May 98, 9 Jun 08) does dashed
REM and beaded lines when "both" is selected.

REM  prev. N-SCRD13.BAS  (by Wm. S. Maddux, Fer de Vries, and Mac Oglesby)
REM  last revision  19 Mar 98

REM Writes a file to C:\filename.txt
REM Convert to dxf with CNVXXXX.exe into filename.txt
REM This file can be used as input in DeltaCad or other
REM CAD programs
REM The basic program calculates points in screen coordinates
REM and the dial is directly  drawn to screen. Data is also output to
REM a text file, as noted above.
REM **Comments with ** are by Fer de Vries
REM **These screen coordinates also are tranformed with the help of
REM **constants xx, yy and scale and then written to filename.txt.
REM **This happens in lines "write #1, flag, x, y"

'filename$ = "Axxx"     'early default - file name limited to 8 characters

'xx = 350      '**shift horizontal
'yy = 250      '**shift vertical
scale = 1 '**scale drawing (normally 1/3)

PRINT "This program prints the dial face for a card"
PRINT "sundial which shows Italian hours"
PRINT "within the range of latitudes N 66.5 to S 66.5."
PRINT
PRINT "NOTE: Have a little patience.  The program may"
PRINT "seem to be hung up when it is not.  Wait for the words"
PRINT "Press any key to continue.": PRINT

10 INPUT "Filename for text output (up to 8 chars) "; filename$

20 INPUT "Latitude in decimal degrees (+66.5 to -66.5) "; L
L3 = ABS(L): IF L3 > 66.5 THEN 20
PRINT

22 PRINT "Want all of the hour lines printed on one sheet,"
INPUT "left and right of a centered dates line?   1 = yes   2 = no "; FT
IF FT <> 1 AND FT <> 2 THEN 22
PRINT : IF FT = 1 THEN 32

PRINT "PM hour lines dashed, AM beaded if 'both' is selected.": PRINT

25 INPUT "Hour Lines:  1 = Morning   2 = Afternoon   3 = Both "; HL
IF (3 - HL) * (HL - 1) < 0 OR INT(HL) <> HL THEN 25
PRINT

30 INPUT "Print dates line at:  1 = Left edge  2 = Right edge "; NN
IF NN <> 1 AND NN <> 2 THEN 30
PRINT : IF NN = 2 THEN NN = -1

32 INPUT "Draw noon lines?  1 = yes   2 = no "; Pn
IF Pn <> 1 AND Pn <> 2 THEN 32
IF FT = 1 THEN NN = 0
PRINT

34 INPUT "Put some text info on screen (only)?  1 = yes   2 = no "; SL
IF SL <> 1 AND SL <> 2 THEN 34

PI = 3.1415927#: R1 = .0174533 'R1 converts degrees to radians

Sd = -200 * NN  'offset for screen display only

DIM M$(14): DIM M2(14)
FOR M1 = 1 TO 12
READ M$: M$(M1) = M$
READ M2: M2(M1) = M2
NEXT M1: RESTORE
SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color

LINE (0, 0)-(640, 480), 1, BF: 'Sets background white

IF SL = 1 THEN LOCATE 1, 2: PRINT "Latitude "; L

OPEN "C:\" + filename$ + ".txt" FOR OUTPUT AS #1
REM **This opens the file  filename.txt

IF SL = 1 THEN LOCATE 28, 58: PRINT "Filename: "; filename$ + ".txt"

IF FT = 1 THEN NN = -1: HL = 1

35 WRITE #1, 9, 87, 0'**General lines in layer L_W
REM  The format for a layer is:  WRITE #1, 9, x, 0
REM  9 is a flag, meaning following lines are placed in a layer
REM  x is the ASCII code of a character from A through Z
REM  The layer name is then L_A, L_B, etc.
REM  The final 0 has no meaning but must be present

REM  Data for arcs for solstices and equinox
A = (90 - L3 + 23.44) * R1  'solstice angle
IF A > .5 * PI THEN A = PI - A
B = (90 - L3 - 23.44) * R1  'solstice angle
IF B > .5 * PI THEN B = PI - B
U = (90 - L3) * R1  'equinox angle
IF U > .5 * PI THEN U = PI - U
C = 120  'radius for solstice
D = 394  'radius for solstice
E = 261  'radius for equinox
IF L < 0 THEN E = 253  'radius for equinox if Latitude<0

REM **For a line startpoint needs flag = 1
REM **Each following point needs  flag = 2

IF NN = -1 THEN 40

LINE (310 + Sd, 30)-(517 + Sd, 30), 0'top horizontal 'Direct output to screen
WRITE #1, 1, (310 - xx) * scale, (-30 + yy) * scale ' **flag, x1, y1
WRITE #1, 2, (517 - xx) * scale, (-30 + yy) * scale ' **flag, x2, y2

LINE (517 + Sd, 35)-(517 + Sd, 25), 0'short right vertical
WRITE #1, 1, (517 - xx) * scale, (-35 + yy) * scale
WRITE #1, 2, (517 - xx) * scale, (-25 + yy) * scale
GOTO 45

40 LINE (123 + Sd, 30)-(330 + Sd, 30), 0'top horizontal
WRITE #1, 1, (123 - xx) * scale, (-30 + yy) * scale ' **flag, x1, y1
WRITE #1, 2, (330 - xx) * scale, (-30 + yy) * scale ' **flag, x2, y2

LINE (123 + Sd, 35)-(123 + Sd, 25), 0'short right vertical
WRITE #1, 1, (123 - xx) * scale, (-35 + yy) * scale
WRITE #1, 2, (123 - xx) * scale, (-25 + yy) * scale

45 LINE (320 + Sd, 10)-(320 + Sd, C + 30), 0'vertical to solstice
WRITE #1, 1, (320 - xx) * scale, (-10 + yy) * scale
WRITE #1, 2, (320 - xx) * scale, (-(C + 30) + yy) * scale

LINE (320 + Sd, 164)-(320 + Sd, 410), 0'vertical Jul 1 to Jan 1
WRITE #1, 1, (320 - xx) * scale, (-164 + yy) * scale
WRITE #1, 2, (320 - xx) * scale, (-410 + yy) * scale

LINE (320 + Sd, D + 30)-(320 + Sd, 470), 0'vertical below solstice
WRITE #1, 1, (320 - xx) * scale, (-(D + 30) + yy) * scale
WRITE #1, 2, (320 - xx) * scale, (-470 + yy) * scale

LINE (312 + Sd, C + 30)-(312 + Sd, D + 30), 0'vertical left of dates
WRITE #1, 1, (312 - xx) * scale, (-(C + 30) + yy) * scale
WRITE #1, 2, (312 - xx) * scale, (-(D + 30) + yy) * scale

LINE (328 + Sd, C + 30)-(328 + Sd, D + 30), 0'vertical right of dates
WRITE #1, 1, (328 - xx) * scale, (-(C + 30) + yy) * scale
WRITE #1, 2, (328 - xx) * scale, (-(D + 30) + yy) * scale

LINE (312 + Sd, C + 30)-(328 + Sd, C + 30), 0'horiz. at solstice
WRITE #1, 1, (312 - xx) * scale, (-(C + 30) + yy) * scale
WRITE #1, 2, (328 - xx) * scale, (-(C + 30) + yy) * scale

LINE (312 + Sd, D + 30)-(328 + Sd, D + 30), 0'horiz. at solstice
WRITE #1, 1, (312 - xx) * scale, (-(D + 30) + yy) * scale
WRITE #1, 2, (328 - xx) * scale, (-(D + 30) + yy) * scale

IF NN = -1 THEN 60

CIRCLE (320 + Sd, 30), C, 0, (1.5 * PI), (1.5 * PI + A)
CIRCLE (320 + Sd, 30), D, 0, (1.5 * PI), (1.5 * PI + B)
CIRCLE (320 + Sd, 30), E, 0, (1.5 * PI), (1.5 * PI + U)
GOTO 65

60 CIRCLE (320 + Sd, 30), C, 0, (1.5 * PI - A), (1.5 * PI)
CIRCLE (320 + Sd, 30), D, 0, (1.5 * PI - B), (1.5 * PI)
CIRCLE (320 + Sd, 30), E, 0, (1.5 * PI - U), (1.5 * PI)

REM **3 records are needed for an arc with flag = 3

65 WRITE #1, 3, (320 - xx) * scale, (-(30 + C) + yy) * scale '**flag,xbegin, ybegin
WRITE #1, 3, (320 - xx) * scale, (-30 + yy) * scale ' **flag, xcenter,ycenter
WRITE #1, 3, C, A / R1 * NN  ' **flag, radius, angle in degrees

WRITE #1, 3, (320 - xx) * scale, (-(30 + D) + yy) * scale
WRITE #1, 3, (320 - xx) * scale, (-30 + yy) * scale
WRITE #1, 3, D, B / R1 * NN

WRITE #1, 3, (320 - xx) * scale, (-(30 + E) + yy) * scale
WRITE #1, 3, (320 - xx) * scale, (-30 + yy) * scale
WRITE #1, 3, E, U / R1 * NN

layer = 0

100 REM **Hourlines are placed in layers L_X and/or L_Y
FOR amhr = 1 TO 2
IF HL = 3 THEN layer = 1: HL = 1: H8 = 3
IF layer = 2 THEN HL = 2
IF HL = 1 THEN WRITE #1, 9, 88, 0  '**Morning hours in layer L_X
IF HL = 2 THEN WRITE #1, 9, 89, 0  '**Afternoon hours in layer L_Y

FOR count = 1 TO 23 ' never more then 23 hourlines

flag = 1  ' **startpoint of a curved hourline

V = 172: w = 354: SW = 1: C9 = 0: C8 = 1
FOR Dn = V TO w
DA = Dn + .5

GOSUB 200
IF L < 0 THEN D4 = D4 * -1  'southern lat
Q1 = -TAN(D4) * TAN(L3 * R1): Q2 = 1 - Q1 * Q1
Q3 = Q1 / SQR(Q2): Q3 = ATN(1) * 2 - ATN(Q3)
Q6 = Q3 * 57.29578 / 15  'Q6 is half day length in hours
hourangle = (Q6 - count) * 15 * R1 'in radians
IF HL = 1 THEN IF hourangle > 0 THEN 160 'print am hour lines only
IF HL = 2 THEN IF hourangle < 0 THEN 160 'print pm hour lines only
REM IF HL=3 then print both am and pm hour lines

H2 = hourangle   'H2 is hour angle in radians
S1 = SIN(L3 * R1) * SIN(D4)
S1 = S1 + COS(L3 * R1) * COS(D4) * COS(H2)
C1 = 1 - S1 * S1: IF C1 > 0 THEN C1 = SQR(C1)
H = ATN(S1 / C1)  'H is altitude of Sun in radians
Rd = 120 + (Dn - V) * 1.5
IF L < 0 THEN Rd = 394 - (Dn - V) * 1.5'southern latitudes
Xz = SIN(H) * Rd: IF Xz < 0 THEN 160

IF SL = 1 THEN LOCATE 1, 66: PRINT "Hour line:"; count

Yz = COS(H) * Rd: IF H8 <> 3 THEN 120
IF amhr = 1 AND HL = 1 THEN 121
IF layer = 1 THEN PSET ((320 + Sd + Xz * NN), (30 + Yz)), 0
IF layer = 1 THEN WRITE #1, flag, (320 + Xz * NN - xx) * scale, (-30 - Yz + yy) * scale

IF layer = 1 THEN 140
C9 = C9 + 1
IF C9 / 3 = INT(C9 / 3) THEN SW = 3 - SW: flag = 1
C8 = 3 - C8
IF SW = 1 OR C8 = 1 THEN WRITE #1, flag, (320 + Xz * NN - xx) * scale, (-30 - Yz + yy) * scale
IF SW = 1 OR C8 = 1 THEN PSET ((320 + Sd + Xz * NN), (30 + Yz)), 0
GOTO 140

120 PSET ((320 + Sd + Xz * NN), (30 + Yz)), 0
WRITE #1, flag, (320 + Xz * NN - xx) * scale, (-30 - Yz + yy) * scale
REM **After first point flag changes into 2
REM **for each following point of a curved line
IF amhr = 1 THEN 140

121 IF H8 <> 3 THEN 140
IF Dn / 2 = INT(Dn / 2) THEN 140
xmid = (320 + Xz * NN - xx) * scale
ymid = (-30 - Yz + yy) * scale
radius = .4
xbegin = xmid: ybegin = ymid - radius
WRITE #1, 3, xbegin, ybegin
WRITE #1, 3, xmid, ymid
WRITE #1, 3, radius * scale, 359

140 flag = 2
160 NEXT Dn
170 NEXT count
NEXT amhr

IF layer = 1 THEN layer = 2: GOTO 100 '**Repeat for afternoon hours
IF Pn = 2 THEN 175
REM Now, draw noon line
WRITE #1, 9, 90, 0 '**Noon line in layer L_Z

flag = 1  ' **For the first point

V = 172: w = 355
FOR Dn = V TO w
DA = Dn + .5

GOSUB 200
IF L < 0 THEN D4 = D4 * -1  'for southern lat.
Am = .5 * PI - L3 * R1 + D4 'Max alt for day in radians
IF Am > .5 * PI THEN Am = PI - Am
Rd = 120 + (Dn - V) * 1.5
IF L < 0 THEN Rd = 394 - (Dn - V) * 1.5  'southern lat
Xm = SIN(Am) * Rd: Ym = COS(Am) * Rd 'Noon line coord.
PSET ((320 + Sd + Xm * NN), (30 + Ym)), 0: 'Draw noon line
WRITE #1, flag, (320 + Xm * NN - xx) * scale, (-30 - Ym + yy) * scale

flag = 2  ' **For following points

NEXT Dn

175 WRITE #1, 9, 87, 0 '**General lines in layer L_W

IF L < 0 THEN 180 'We need southern latitude

FOR Qs = 1 TO 6  'Draw month marks for Jan - Jun
DA = M2(Qs)
Rd = 120 + (183 - (DA + 10)) * 1.5
LINE (320 + Sd, Rd + 30)-(328 + Sd, Rd + 30), 0
WRITE #1, 1, (320 - xx) * scale, (-(Rd + 30) + yy) * scale
WRITE #1, 2, (328 - xx) * scale, (-(Rd + 30) + yy) * scale
NEXT Qs

IF SL = 1 THEN LOCATE 28, 2: PRINT "Lower solstice is Dec21"

FOR Q1 = 7 TO 12 'Draw month marks for Jul - Dec
DA = M2(Q1)
Rd = 120 + (DA - V) * 1.5
LINE (320 + Sd, Rd + 30)-(312 + Sd, Rd + 30), 0
WRITE #1, 1, (320 - xx) * scale, (-(Rd + 30) + yy) * scale
WRITE #1, 2, (312 - xx) * scale, (-(Rd + 30) + yy) * scale
NEXT Q1
GOTO 185

REM Invert the months for southern latitudes
180 FOR Qs = 1 TO 6 'Draw month marks for Jan - Jun
DA = M2(Qs)
Rd = 394 - (183 - (DA + 10)) * 1.5
LINE (312 + Sd, Rd + 30)-(320 + Sd, Rd + 30), 0
WRITE #1, 1, (312 - xx) * scale, (-(Rd + 30) + yy) * scale
WRITE #1, 2, (320 - xx) * scale, (-(Rd + 30) + yy) * scale
NEXT Qs

IF SL = 1 THEN LOCATE 28, 2: PRINT "Lower solstice is Jun21"

FOR Q1 = 7 TO 12 'Draw month marks for Jul - Dec
DA = M2(Q1)
Rd = 394 - (DA - V) * 1.5
LINE (320 + Sd, Rd + 30)-(328 + Sd, Rd + 30), 0
WRITE #1, 1, (320 - xx) * scale, (-(Rd + 30) + yy) * scale
WRITE #1, 2, (328 - xx) * scale, (-(Rd + 30) + yy) * scale
NEXT Q1

185 IF NN = 1 OR FT = 2 THEN 190

NN = 1: HL = 2: GOTO 35

190 CLOSE #1  '**Close file xxxx.txt

END

200 L2 = 4.87533 + DA * .0172028
G = 6.22578 + DA * .0172028
L1 = L2 + SIN(G) * .0334406 + SIN(2 * G) * .0003491
S5 = SIN(L1) * .3978105
D4 = 2 * ATN(S5 / (1 + SQR(1 - S5 * S5))):    'D4 is Declin. in radians
RETURN

DATA "JAN ",0,"FEB ",31,"MAR ",59,"APR ",90
DATA "MAY ",120,"JUN ",151,"JUL ",181,"AUG ",212
DATA "SEP ",243,"OCT ",273,"NOV ",304,"DEC ",334

