CLS : PRINT "HMSTPS1.BAS  by Mac Oglesby  (000313, last revised 080528)"
PRINT "Horizontal Monofilar (sundial with date arcs and unfolded analemma),"
PRINT "showing Standard Time with a Pole Style (or as a shadow plane dial.)"

REM  *** INITIALIZATION SECTION ***
REM  **(1)** You MUST set filename$ to suit your situation
REM  **(2)** You MUST specify latitude, local longitude, time zone meridian,
REM  month to start, radius of inner arc, and hour line step size.

filename$ = "C:\HMSTPS1.txt"     '[disk:] [path] filename.txt
PHI = 43        'latitude of the dial in decimal deg. (0 < latitude < 66.5)
LocLong = 72.58    'longitude of local meridian (decimal degrees, west +)
Meridian = 75    'longitude of standard time zone meridian (decimal deg.)
EoTyesno = 1      'Want Eot correction?  (1=yes,  0=no)
STRT = 1          '1st of which month to start (Jan=1,Feb=2,...Dec=12)
Min = 375         'radius of inner arc  (outermost arc radius = Min+366)
SPZ = .5        'step size for hour lines (.5 draws half-hour lines)
   'N.B.--repeating decimals (e.g. 1/3, 1/6) may produce poor results  :-(
REM  *** END OF INITIALIZATION SECTION ***

PI# = 3.141592653#
D2R = PI# / 180   'convert degrees to radians
R2D = 180 / PI#   'convert radians to degrees

PRINT
PRINT "For latitudes greater than 0 and less than 66.5, this program"
PRINT "draws a horizontal dial face which has date arcs and an 'unfolded'"
PRINT "analemma.  Longitude and Equation of Time corrections may be included."
PRINT "To avoid any longitude correction, input same values for longitude"
PRINT "and time zone.  Input 0 for EoTyesno to turn off EoT correction."
PRINT
PRINT "Only some lines appear on the screen, but all data for dial lines"
PRINT "are written to a .txt file.  Fer de Vries' program CNVXXXX.EXE"
PRINT "(distributed by NASS as part of certain issues of The Compendium)"
PRINT "may be used to create, from the .txt file, a .dxf file for use by"
PRINT "a CAD program such as DeltaCad.  Algorithms published by Fer de"
PRINT "Vries are used to calculate EoT and solar declination."
PRINT
PRINT
PRINT
PRINT "Press any key to continue..."
10 IF INKEY$ = "" THEN 10
CLS
PRINT "Here are the current parameters.  To alter any values, list"
PRINT "the program and make changes in the INITIALIZATION SECTION."
PRINT
PRINT
PRINT "Text file name for output:  "; filename$
PRINT
PRINT "Latitude: "; PHI
PRINT
PRINT "Longitude: "; LocLong
PRINT
PRINT "Time zone meridian: "; Meridian
PRINT
PRINT "EoT correction?  (1=yes,  0=no): "; EoTyesno
PRINT
PRINT "Date of innermost arc (1=Jan 1st, 7=Jul 1st, etc.): "; STRT
PRINT
PRINT "Radius of innermost arc: "; Min
PRINT
PRINT "Step size for hour lines: "; SPZ
PRINT
PRINT
PRINT
PRINT "Press any key to continue..."
12 IF INKEY$ = "" THEN 12

OPEN filename$ FOR OUTPUT AS #1
Loff = (Meridian - LocLong) * 4  'longitude offset in minutes of time

DIM M(13): DIM M2(13): DIM M4(13)
FOR J = 1 TO 12: READ M$       'read names of months
READ M: M(J) = M       'day of year for 1st of month (Jan 1 = 1)
READ M2: M2(J) = M2              'how many days in each month month
NEXT J
count = STRT
FOR J = 1 TO 12
M4(count) = M2(count)
count = count + 1: IF count = 13 THEN count = 1
NEXT J
M4(13) = M(STRT)

SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color
LINE (0, 0)-(640, 480), 1, BF      'Sets background white
LOCATE 1, 1: PRINT "Calculating..."

DIM EoT(365): DIM DECL(365): DIM HD(365)
FOR NR = 1 TO 365    'calc & store Eot, Decl, half-day-length values for yr
REM  EoT, Decl calculated for 1998 using Fer de Vries' method
LOCATE 2, 1: PRINT "Day of yr. "; NR
L8 = NR * 360 / 365.2422 - 80.535132#     'degrees
E1 = -107.0605 * SIN(L8 * D2R) - 428.6697 * COS(L8 * D2R)
E2 = 596.1009 * SIN(2 * L8 * D2R)
E3 = -2.0898 * COS(2 * L8 * D2R) + 4.4173 * SIN(3 * L8 * D2R)
E4 = 19.2776 * COS(3 * L8 * D2R) - 12.7338 * SIN(4 * L8 * D2R)
E = E1 + E2 + E3 + E4    'EoT in seconds of time
EoT(NR) = EoTyesno * (E / 60)    'EoT (in minutes) for this day, or zero
LAM1 = L8 + .4277 * SIN(D2R * L8) + 1.8664 * COS(D2R * L8)
LAM2 = -.0181 * SIN(D2R * 2 * L8) + .0087 * COS(D2R * 2 * L8)
LAMDA = LAM1 + LAM2     'degrees
D1 = SIN(LAMDA * D2R) * SIN(23.43954 * D2R)
DecSun = ATN(D1 / SQR(1 - D1 * D1)) * R2D     'declination of sun in degrees
DECL(NR) = DecSun      'store DecSun for this day
D2 = -TAN(PHI * D2R) * TAN(DecSun * D2R)
HDL = (ATN(1) * 2 - ATN(D2 / SQR(1 - D2 * D2))) * R2D    'degrees
HD(NR) = HDL     'store HalfDayLength for this day
IF NR = 172 THEN MaxDL = INT(HDL / 15 + 1)  'hours for half of longest day
IF PHI < 0 AND NR = 355 THEN MaxDL = INT(HDL / 15 + 1)  'so. hemisphere
NEXT NR

REM  Certain helpful information is printed to screen (only).
LOCATE 1, 1: PRINT "Std. Time Meridian = "; Meridian;
PRINT "  Local Meridian = "; LocLong;
PRINT "  Latitude = "; PHI
LOCATE 2, 1: PRINT "Dates increase moving outward from dial's center.  ";
PRINT "Innermost month is "; STRT
LOCATE 3, 1: PRINT "Inner arc size is "; Min
LOCATE 4, 1: IF EoTyesno = 1 THEN PRINT "EoT correction included"
LOCATE 4, 1: IF EoTyesno = 0 THEN PRINT "No EoT correction"
LOCATE 29, 1: PRINT "filename$ = "; filename$;

X0 = 320: Y0 = 300     'screen coordinates of origin for dial's center

REM Screen and drawing plots may be scaled.  Normally, drX=drY; scX=scY.
drX = .01475: drY = .01475     'drawing scale opens near 1
scX = .25: scY = .25      'screen plot scale

FOR Hour = -MaxDL TO MaxDL STEP SPZ   'if SPZ=.5, draw half-hour lines
IF Hour = INT(Hour) THEN WRITE #1, 9, 65, 0   'whole hour curves in layer A
IF Hour <> INT(Hour) THEN WRITE #1, 9, 66, 0   'fractional hours in layer B
Day = M(STRT)
flag = 1
FOR J = 1 TO 366
IF J = 366 THEN Day = M(STRT)
HA = Hour * 15 + (Loff + EoT(Day)) / 4   'std time hour angle of sun
IF HA > HD(Day) THEN flag = 1: GOTO 115
IF HA < -HD(Day) THEN flag = 1: GOTO 115
A = ATN(SIN(PHI * D2R) * TAN(HA * D2R)) * R2D
IF HA < -90 THEN A = A + 180
IF HA > 90 THEN A = A + 180
R = J + Min
Y = -R * COS(A * D2R): X = R * SIN(A * D2R)
PSET (X * scX + X0, Y * scY + Y0), 0   'plot points on screen
REM Reverse the sign of Y values written to text file.
WRITE #1, flag, X * drX, -Y * drY    'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
115 Day = Day + 1: IF Day = 366 THEN Day = 1: flag = 1
NEXT J
NEXT Hour

WRITE #1, 9, 67, 0          'sunrise/set hour lines in layer C
FOR J = -1 TO 1 STEP 2
Day = M(STRT): flag = 1
FOR K = 1 TO 366
IF K = 366 THEN Day = M(STRT)
A = ATN(SIN(PHI * D2R) * TAN(J * HD(Day) * D2R)) * R2D
IF HD(Day) < -90 THEN A = A - 180
IF HD(Day) > 90 THEN A = A + 180
R = K + Min
Y = -R * COS(A * D2R): X = R * SIN(A * D2R)
PSET (X * scX + X0, Y * scY + Y0), 0    'plot points on screen
WRITE #1, flag, X * drX, -Y * drY    'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
Day = Day + 1: IF Day = 366 THEN Day = 1: flag = 1
NEXT K
NEXT J

WRITE #1, 9, 68, 0     'arcs in layer D
count = STRT: arc = 1
FOR J = 1 TO 13
Day = M(count)
IF J = 13 THEN arc = 366: Day = M(STRT)
A = ATN(SIN(PHI * D2R) * TAN(HD(Day) * D2R)) * R2D
IF HD(Day) > 90 THEN A = A + 180
IF HD(Day) < -90 THEN A = A - 180
R = arc + Min
Y1 = R * COS(A * D2R): X1 = R * SIN(A * D2R)
WRITE #1, 3, X1 * drX, Y1 * drY
WRITE #1, 3, 0, 0
WRITE #1, 3, R * drX, 2 * ABS(A)
arc = arc + M4(count)
count = count + 1: IF count = 13 THEN count = 1
NEXT J
CLOSE #1
DATA "JAN",1,31,"FEB",32,28,"MAR",60,31,"APR",91,30
DATA "MAY",121,31,"JUN",152,30,"JUL",182,31,"AUG",213,31
DATA "SEP",244,30,"OCT",274,31,"NOV",305,30,"DEC",335,31
END



