CLS : PRINT "HORDIAL7.BAS  by Mac Oglesby  981028 Rev. 20080622"
PRINT
PRINT "This program prints the hour lines for a monofilar (polestyle)"
PRINT "horizontal sundial.  Longitude correction may be included."
PRINT "The shape of the sundial is assumed to be round."
PRINT "Hour marks and fractionals are drawn within a circle whose"
PRINT "center may be offset from the dial's center (that point to which"
PRINT "hour lines converge and where the pole style penetrates the dial)."
PRINT "Whole hour lines and fractional hour lines are different lengths."
PRINT "The dial is drawn on the screen, and data are output to a text file"
PRINT "which may be used to create a .dxf file for CAD input."
PRINT "Fer de Vries' program CNVXXXX, distributed by NASS with certain"
PRINT "issues of The Compendium, will do such a conversion."
PRINT
PRINT "Default output text file is   C:\HORDIAL7.txt"
PRINT "To change the file name, LIST the program and change filename$."

PRINT "To change which fractional hours are included, or to modify the"
PRINT "lengths of these lines, alter the appropriate values within"
PRINT "the program."
PRINT "This program isn't recommended for very low latitudes."
PRINT
PRINT
INPUT "Latitude in decimal degrees (+N)  "; L1
PRINT
INPUT "Longitude in decimal degrees (+W)  "; L2
PRINT
PRINT "(For no longitude correction, input meridian same as longitude.)"
INPUT "Time Zone Meridian (+W)  "; Mer
Loff = (Mer - L2)      'longitude offset in degrees
PRINT
INPUT "Radius of circle for hour marks  [300 suggested]"; Rad
PRINT
PRINT "Distance hour marks circle is offset from dial center  "
INPUT "[suggested: 1/4 to 1/2 half the radius of hour marks circle]"; Oset
PRINT
INPUT "Hour to start dial hour lines  "; STARTHour
PRINT
INPUT "Hour to end dial hour lines (24 hr system)  "; ENDHour

filename$ = "C:\HORDIAL7.txt"     '8 characters maximum for filemane
SCREEN 11: CLS     'VGA or SVGA 640 x 480, 2 color
LINE (0, 0)-(640, 480), 1, BF     'set background white
OPEN filename$ FOR OUTPUT AS #1
D2R = 3.141593 / 180     'convert degrees to radians
R2D = 180 / 3.141593     'convert radians to degrees
xp = 320   'shift horizontal for screen coords.
yp = 240   'shift vertical for screen coords.
sc1 = .5   'scaling for screen coords.
sc2 = .1   'scaling for DXF file
WRITE #1, 9, 86, 0            'meridian line in layer V on drawing
x = 0: y = 0
WRITE #1, 1, x, y: WRITE #1, 2, x, y - Rad * sc2   'meridian line on drawing
x = 0 + xp: y = 0 + yp   'center of hour marks circle at (x=0,y=0)
LINE (x, y)-(x, y + Rad * sc1), 0                'meridian line on screen
WRITE #1, 9, 87, 0   'layer W on drawing
RC = 2 * sc1    'size (radius) of little circle
CIRCLE (x, y), RC, 0  'small circle at center of hour marks circle on screen
CIRCLE (x, y), Rad * sc1, 0        'circle outside hour marks on screen
x = 0 * sc1 + xp: y = Oset * sc1 + yp
CIRCLE (x, y), RC * 2, 0           'circle at center of dial on screen
x = 0: y = 0
WRITE #1, 3, x + Rad * sc2, y      'circle outside hour marks on drawing
WRITE #1, 3, x, y
WRITE #1, 3, Rad * sc2, 359.9
x = 0: y = 0 - Oset * sc2                        'dial center on drawing
WRITE #1, 1, x - 10 * sc2, y              'cross at dial center on drawing
WRITE #1, 2, x + 10 * sc2, y
WRITE #1, 1, x, y + 10 * sc2
WRITE #1, 2, x, y - 10 * sc2

K = 15  'set K for length of shortest hour line--others are multiples
STARTHour = STARTHour * 12: ENDHour = ENDHour * 12
FOR Hr1 = STARTHour TO ENDHour
Hr = Hr1 / 12
HA = (Hr - 12) * 15 + Loff    'hour angle in degrees (with long. correction)
HLA = ATN(TAN(HA * D2R) * SIN(L1 * D2R)) * R2D   'hour line angle (deg)
IF ABS(HA) > 90 THEN HLA = HLA - 180       'kludge
IF HA > 90 THEN HLA = HLA + 360        'kludge
IF ABS(HA) = 90 THEN HLA = HLA * -1     'kludge
x0 = 0 + xp: y0 = Oset * sc1 + yp   'x0,y0 is center of dial
A = SIN(HLA * D2R) * Oset / Rad   'angle opposite triangle side running from center
A = ATN(A / SQR(1 - A * A)) * R2D     'of dial to center of hour marks circle
B = 90 - A - HLA
x1 = Rad * COS(B * D2R)
y1 = -Rad * SIN(B * D2R)
xs1 = x1 * sc1 + xp: ys1 = y1 * sc1 + yp
REM ***Use apostrophes (') to turn specific hour lines on or off***
REM   5 minute intervals: (put in layer A)
Rmin = Rad - K: WRITE #1, 9, 65, 0                                  'layer A
REM   10 minute intervals: (put in layer B)
'IF Hr1 / 2 = INT(Hr1 / 2) THEN Rmin = Rad - 2 * K: WRITE #1, 9, 66, 0    'B
REM   15 minute intervals: (put in layer C)
IF Hr1 / 3 = INT(Hr1 / 3) THEN Rmin = Rad - 2 * K: WRITE #1, 9, 67, 0     'C
REM   20 minute intervals: (put in layer D)
'IF Hr1 / 4 = INT(Hr1 / 4) THEN Rmin = Rad - 3 * K: Write #1, 9, 68, 0    'D
REM   30 minute intervals: (put in layer E)
IF Hr1 / 6 = INT(Hr1 / 6) THEN Rmin = Rad - 3 * K: WRITE #1, 9, 69, 0     'E
REM   60 minute intervals: (put in layer F)
IF Hr1 / 12 = INT(Hr1 / 12) THEN Rmin = Rad - 4 * K: WRITE #1, 9, 70, 0   'F
A = SIN(HLA * D2R) * Oset / Rmin
A = ATN(A / SQR(1 - A * A)) * R2D
B = 90 - A - HLA
x4 = Rmin * COS(B * D2R)
y4 = -Rmin * SIN(B * D2R)
xs4 = x4 * sc1 + xp: ys4 = y4 * sc1 + yp
LINE (xs1, ys1)-(xs4, ys4), 0     'hour and fractional marks
WRITE #1, 1, x1 * sc2, -y1 * sc2: WRITE #1, 2, x4 * sc2, -y4 * sc2  'hr marks
NEXT Hr1

LOCATE 1, 1: PRINT "Lat: "; L1
LOCATE 2, 1: PRINT "Long: "; L2
LOCATE 3, 1: PRINT "Meridian: "; Mer
LOCATE 1, 18: PRINT "Radius of hour marks circle: "; Rad
LOCATE 2, 18
PRINT "Distance hour marks circle is offset from dial center: "; Oset
LOCATE 26, 1: PRINT "Start Hour: "; STARTHour / 12
LOCATE 27, 1: PRINT "End Hour: "; ENDHour / 12
LOCATE 28, 1: PRINT "filename$= "; filename$
CLOSE #1
END

