REM  POLARSCL  by Mac Oglesby 990709 rev. 20080530
PRINT "POLARSCL draws hour lines for polar dial with upturned ends,"
PRINT "which serve as gnomons. Dial shape is |____|. Scales are drawn"
PRINT "for the ends as well as for the sun-facing surface."
PRINT
PRINT "Lines data are stored in a text file, which may be converted to"
PRINT "a DXF file by Fer de Vries' utility CNVXXXX.EXE."
PRINT "However, no lines appear on the screen."
PRINT
PRINT "LIST this program to change parameters in initialization section."

REM  *** INITIALIZATION SECTION ***
REM  *** (1) set filename
REM  *** (2) set how many hours shown on sun-facing plate (4.5 suggested,
REM  leaving 1.5 for upturned end).
filename$ = "C:\filename.txt"  '8 character limit for filename
HOURS = 4.5   'time interval for sun-facing plate in decimal hours
REM  *** END INITIALIZATION ***

HA = HOURS * 15
PRINT : PRINT "filename = ", filename$
OPEN filename$ FOR OUTPUT AS #1
D2R = 3.141593 / 180    'convert degrees to radians
REM  Use a specific size for H, but drawing may be scaled in CAD program.
H = 76.2   'H = height of gnomon (length of upturned ends)
REM  First, draw hour marks for sun-facing surface

FOR J = 0 TO HA STEP 1.25  'hr angles for sun-facing plate, 5 minutes apart
X = H * TAN(J * D2R)   'distance from gnomon foot to hour line
L = 4   'size of 5 minute hour marks is 4
M = J * 12
IF M / 45 = INT(M / 45) THEN L = 8   'quarter-hour marks are 8
IF M / 90 = INT(M / 90) THEN L = 12   'half-hour marks are 12
IF M / 180 = INT(M / 180) THEN L = 20   'whole-hour marks are 20
WRITE #1, 1, X, 0   'point to begin hour line
WRITE #1, 2, X, L   'point to end hour line
NEXT J
WRITE #1, 1, 0, 0   'point to begin line running length of sun-facing surface
WRITE #1, 2, X, 0   'point to end line

X1 = X + 10 + H   'small distance before drawing the end plate scale
HA = (6 - HOURS) * 15
H1 = H / TAN(HA * D2R)   'gnomon height = length of sun-facing surface

FOR J = 0 TO HA STEP 1.25   'hr angles for end plates, 5 minutes apart
X = X1 - H1 * TAN(J * D2R)   'distance from shadow casting edge
L = 4: M = J * 12
IF M / 45 = INT(M / 45) THEN L = 8
IF M / 90 = INT(M / 90) THEN L = 12
IF M / 180 = INT(M / 180) THEN L = 20
WRITE #1, 1, X, 0   'point to begin hour mark
WRITE #1, 2, X, L   'point to end hour mark
NEXT J
WRITE #1, 1, X1, 0   'point to begin line running length of upturned end
WRITE #1, 2, X1 - H, 0   'point to end line
CLOSE #1   'close the file
END   'end program

