REM twoCDFs.BAS (Two Complementary Dial Faces)
REM slight revision of STHOR11x.BAS  (Standard Time HORizontal sundial)
REM    Has length of half day shortened by 10 minutes,
REM    allowing for 2 nested dial faces without overlap if one starts at
REM    Jan 1st and the other at July 1st.
REM Mac Oglesby  000225 last rev. 080618  (uses Fer's EoT & Decl. algorithms)
REM This program draws a horizontal dial face which has date
REM rings and 'unfolded' analemmas.
REM Use CNVXXXX.EXE to create a .dxf file from the .txt file.

REM      BEGINNING of INITIALIZATION SECTION

REM  ****(1)****  You MUST set filename$ to suit your situation

filename$ = "C:\twoCDFs.txt"     '[disk:] [path] filename.txt

REM  ****(2)****  You MUST specify latitude, local longitude, standard
REM  meridian, start date (1st of which month), and radius of inner arc.

PHI = 43.03        'latitude in decimal deg., (north latitudes < 66 deg.)
                    'program wasn't tested for southern latitudes
                    'not useful for low latitudes
LocLong = 72.57    'longitude of local meridian (decimal degrees, west +)
Meridian = 75      'longitude of standard time zone meridian (decimal deg.)
STRT = 7          'month to start (Jan=1,Feb=2,...Dec=12)
Min = 375         'radius of inner arc

REM       END of INITIALIZATION SECTION

OPEN filename$ FOR OUTPUT AS #1
Loff = (Meridian - LocLong) * 4  'longitude offset in minutes of time
PI# = 3.141592653#
D2R = PI# / 180   'convert degrees to radians
R2D = 180 / PI#   'convert radians to degrees

DIM M(13): DIM M2(13): DIM M4(13)
FOR J = 1 TO 12: READ M$       'read names of months
READ M: M(J) = M       'day of year for 1st of month (Jan 1 = 1)
READ M2: M2(J) = M2              'how many days in each month month
NEXT J
count = STRT
FOR J = 1 TO 12
M4(count) = M2(count)
count = count + 1: IF count = 13 THEN count = 1
NEXT J
M4(13) = M(STRT)

SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color
LINE (0, 0)-(640, 480), 1, BF      'Sets background white
LOCATE 1, 1: PRINT "Calculating..."

DIM EOT(365): DIM DECL(365): DIM HD(365)
FOR NR = 1 TO 365    'calc & store Eot, Decl, half-day-length values for yr
REM  EoT, Decl calculated for 1998 using Fer de Vries' method
LOCATE 2, 1: PRINT "Day of yr. "; NR
L8 = NR * 360 / 365.2422 - 80.535132#     'degrees
E1 = -107.0605 * SIN(L8 * D2R) - 428.6697 * COS(L8 * D2R)
E2 = 596.1009 * SIN(2 * L8 * D2R)
E3 = -2.0898 * COS(2 * L8 * D2R) + 4.4173 * SIN(3 * L8 * D2R)
E4 = 19.2776 * COS(3 * L8 * D2R) - 12.7338 * SIN(4 * L8 * D2R)
E = E1 + E2 + E3 + E4    'EoT in seconds of time
EOT(NR) = E / 60      'store EoT (in minutes) for this day
LAM1 = L8 + .4277 * SIN(D2R * L8) + 1.8664 * COS(D2R * L8)
LAM2 = -.0181 * SIN(D2R * 2 * L8) + .0087 * COS(D2R * 2 * L8)
LAMDA = LAM1 + LAM2     'degrees
D1 = SIN(LAMDA * D2R) * SIN(23.43954 * D2R)
DecSun = ATN(D1 / SQR(1 - D1 * D1)) * R2D     'declination of sun in degrees
DECL(NR) = DecSun      'store DecSun for this day
D2 = -TAN(PHI * D2R) * TAN(DecSun * D2R)
HDL = (ATN(1) * 2 - ATN(D2 / SQR(1 - D2 * D2))) * R2D    'degrees
HD(NR) = HDL - 2.5   'store HalfDayLength minus 10 minutes for this day
IF NR = 172 THEN MaxDL = INT(HDL / 15 + 1)  'hours for half of longest day
NEXT NR

REM  Certain helpful information is printed to screen (only).
LOCATE 1, 1: PRINT "Std. Time Meridian = "; Meridian;
PRINT "  Local Meridian = "; LocLong;
PRINT "  Latitude = "; PHI
LOCATE 2, 1: PRINT "Dates increase moving outward from dial's center.  ";
PRINT "Innermost month is "; STRT
LOCATE 29, 1: PRINT "filename$ = "; filename$;

X0 = 320: Y0 = 240     'screen coordinates of origin for dial's center

REM Drawing may be scaled.  Normally, scX=scY.  Screen plot isn't affected.
scX = .01475: scY = .01475     'drawing scale opens near 1

FOR Hour = -MaxDL TO MaxDL STEP .5   'use .25 steps for quarterhours
IF Hour = INT(Hour) THEN WRITE #1, 9, 65, 0   'whole hour curves in layer A
IF Hour <> INT(Hour) THEN WRITE #1, 9, 66, 0   'fractional hours in layer B
CurDay = M(STRT)
flag = 1
FOR J = 1 TO 366
IF J = 366 THEN CurDay = M(STRT)
HA = Hour * 15 + (Loff + EOT(CurDay)) / 4   'std time hour angle of sun
IF HA > HD(CurDay) THEN flag = 1: GOTO 115
IF HA < -HD(CurDay) THEN flag = 1: GOTO 115
A = ATN(SIN(PHI * D2R) * TAN(HA * D2R)) * R2D
IF HA < -90 THEN A = A - 180
IF HA > 90 THEN A = A + 180
R = J + Min
X = R * COS(A * D2R): Y = R * SIN(A * D2R)
PSET (X * .5 + X0, Y * .5 + Y0), 0         'plot points on screen
REM Reverse the sign of Y values written to text file.
WRITE #1, flag, (X + shX) * scX, -(Y + shY) * scY    'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
115 CurDay = CurDay + 1: IF CurDay = 366 THEN CurDay = 1: 'flag = 1
NEXT J
NEXT Hour

WRITE #1, 9, 67, 0          'sunrise/set hour lines in layer C
FOR J = -1 TO 1 STEP 2
CurDay = M(STRT): flag = 1
FOR K = 1 TO 366
IF K = 366 THEN CurDay = M(STRT)
A = ATN(SIN(PHI * D2R) * TAN(J * HD(CurDay) * D2R)) * R2D
IF HD(CurDay) < -90 THEN A = A - 180
IF HD(CurDay) > 90 THEN A = A + 180
R = K + Min
X = R * COS(A * D2R): Y = R * SIN(A * D2R)
PSET (X * .5 + X0, Y * .5 + Y0), 0         'plot points on screen
WRITE #1, flag, (X + shX) * scX, -(Y + shY) * scY    'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
CurDay = CurDay + 1: IF CurDay = 366 THEN CurDay = 1: 'flag = 1
NEXT K
NEXT J

LOCATE 15, 1: PRINT "Date arcs are not drawn on screen, ";
PRINT "but arc data are written to text file."
WRITE #1, 9, 68, 0     'arcs in layer D
count = STRT: Arc = 1
FOR J = 1 TO 13
day = M(count)
IF J = 13 THEN Arc = 366: day = M(STRT)
A1 = ATN(SIN(PHI * D2R) * TAN(HD(day) * D2R)) * R2D
IF HD(day) > 90 THEN A1 = A1 + 180
IF HD(day) < -90 THEN A1 = A1 - 180
R = Arc + Min
X1 = R * COS(A1 * D2R): Y1 = R * SIN(A1 * D2R)
WRITE #1, 3, X1 * scX, -Y1 * scY
WRITE #1, 3, 0, 0
WRITE #1, 3, R * scX, 2 * ABS(A1)
Arc = Arc + M4(count)
count = count + 1: IF count = 13 THEN count = 1
NEXT J

CLOSE #1
DATA "JAN",1,31,"FEB",32,28,"MAR",60,31,"APR",91,30
DATA "MAY",121,31,"JUN",152,30,"JUL",182,31,"AUG",213,31
DATA "SEP",244,30,"OCT",274,31,"NOV",305,30,"DEC",335,31
END


