CLS : PRINT "VDSTP11x.BAS  by Mac Oglesby  (000313; rev 020801,080623)"
PRINT "Vertical Declining sundial with date arcs and unfolded analemmas,"
PRINT "showing Standard Time with a Pole Style (or as a shadow plane dial)."
PRINT "You may choose to omit EoT and/or longitude correction."

REM  *** INITIALIZATION SECTION ***
REM  **(1)** You MUST set filename$ to suit your situation
REM  **(2)** You MUST specify latitude, longitude, time zone meridian,
REM  declination of dial, EoT option, starting month, radius of inner arc,
REM  and hour step size.

filename$ = "C:\VDSTP11x.txt"     '[disk:] [path] filename.txt
PHI = 42.85    'latitude of the dial in decimal deg. (0 < latitude < 66.5)
LocLong = 72.55    'longitude of local meridian (decimal degrees, west +)
TZM = 75    'longitude of standard time zone meridian (decimal deg.)
DecDial = -46.56    'Declination of dial from south (west +)
EoTyesno = 1      'Want Eot correction?  (1=yes,  0=no)
STRT = 1          '1st of which month to start (Jan=1,Feb=2,...Dec=12)
Min = 375         'radius of inner arc  (outermost arc radius = Min+366)
SPZ = .25        'step size for hour lines (.5 draws half-hour lines)
   'N.B.--repeating decimals (e.g. 1/3, 1/6) may produce poor results  :-(

REM *** END OF INITIALIZATION SECTION ***

PI# = 3.141592653#
D2R = PI# / 180   'convert degrees to radians
R2D = 180 / PI#   'convert radians to degrees

REM ***Compute equivalent plane

REM   Sin v = -Cos PHI Cos DecDial
XX = -COS(PHI * D2R) * COS(DecDial * D2R)
v = ATN(XX / SQR(1 - XX * XX)) * R2D       'equivalent latitude

REM   Sin ts = Sin i Sin DecDial / Cos v          (vertical dial, so i=90)
XX = (SIN(90 * D2R) * SIN(DecDial * D2R) / COS(v * D2R))
ts = ATN(XX / SQR(1 - XX * XX)) * R2D         'hour angle of substyle

REM   Sin b = Cos PHI Sin DecDial / Cos v
XX = (COS(PHI * D2R) * SIN(DecDial * D2R) / COS(v * D2R))
b = ATN(XX / SQR(1 - XX * XX)) * R2D         'y-axis to substyle angle

Loff = (TZM - LocLong) * 4      'longitude offset in minutes of time
Loff = Loff + (0 - ts) * 4          'total longitude correction

PRINT
PRINT "For latitudes greater than 0 and less than 66.5, this program draws"
PRINT "a vertical declining dial face which has date arcs and 'unfolded'"
PRINT "analemmas. As a guideline, use this:  -75 < declination < 75."
PRINT "Longitude and Equation of Time corrections may be included."
PRINT "To avoid any longitude correction, input same values for longitude"
PRINT "and time zone. Input 0 for EoTyesno to turn off EoT correction."
PRINT "Lines are drawn for noon and for the substyle."
PRINT
PRINT "Only some lines appear on the screen, but all data for dial lines"
PRINT "are written to a .txt file.  Fer de Vries' program CNVXXXX.EXE"
PRINT "(distributed by NASS as part of certain issues of The Compendium)"
PRINT "may be used to create, from the .txt file, a .dxf file for use by"
PRINT "a CAD program such as DeltaCad.  Algorithms published by Fer de"
PRINT "Vries are used to calculate EoT and solar declination."
PRINT
PRINT
PRINT
PRINT "Press any key to continue..."
10 IF INKEY$ = "" THEN 10
CLS
PRINT "Here are the current parameters.  To alter any values, LIST"
PRINT "the program and make changes in the INITIALIZATION SECTION."
PRINT
PRINT "Text file name for output:  "; filename$
PRINT
PRINT "Latitude of dial: "; PHI
PRINT "Longitude of dial: "; LocLong
PRINT "Time zone meridian: "; TZM
PRINT "Declination of dial (South=0, West pos.): "; DecDial
PRINT
PRINT "EoT correction?  (1=yes,  0=no): "; EoTyesno
PRINT "Date of innermost arc (1=Jan 1st, 7=Jul 1st, etc.): "; STRT
PRINT "Innermost arc radius: "; Min
PRINT "Step size for hour lines: "; SPZ
PRINT
PRINT
PRINT "Equivalent latitude: "; v
PRINT "Hour angle of the substyle: "; ts
PRINT "Total longitude correction in minutes of time: "; Loff
PRINT "y-axis to substyle angle: "; b
PRINT
PRINT
PRINT "Press any key to continue..."
12 IF INKEY$ = "" THEN 12

OPEN filename$ FOR OUTPUT AS #1
DIM M(13): DIM M2(13): DIM M4(13)
FOR J = 1 TO 12: READ M$       'read names of months
READ M: M(J) = M       'day of year for 1st of month (Jan 1 = 1)
READ M2: M2(J) = M2              'how many days in each month month
NEXT J
count = STRT
FOR J = 1 TO 12
M4(count) = M2(count)
count = count + 1: IF count = 13 THEN count = 1
NEXT J
M4(13) = M(STRT)

SCREEN 11: CLS     'VGA or SVGA 640 by 480, 2 color
LINE (0, 0)-(640, 480), 1, BF      'Sets background white

REM  Certain helpful information is printed to screen (only).
LOCATE 1, 1: PRINT "Latitude = "; PHI;
PRINT "  Local Meridian = "; LocLong;
PRINT "  Time zone Meridian = "; TZM
LOCATE 2, 1: PRINT "Inner arc size is "; Min; "     ";
IF EoTyesno = 1 THEN PRINT "EoT correction included "
IF EoTyesno = 0 THEN PRINT "No EoT correction "
LOCATE 3, 1: PRINT "Dates increase moving outward from dial's center.  ";
PRINT "Innermost month is "; STRT
LOCATE 4, 1: PRINT "Declination of dial = "; DecDial; "     ";
PRINT "equivalent latitude = "; v
LOCATE 5, 1: PRINT "hour-angle of substyle = "; ts; "     ";
PRINT "y-axis to substyle angle = "; b
LOCATE 6, 1: PRINT "total longitudinal offset (minutes of time) = "; Loff
LOCATE 29, 1: PRINT "filename$ = "; filename$;

PHI = v        'switch to equivalent latitude

DIM EoT(365): DIM Decl(365): DIM HD(365)
FOR NR = 1 TO 365    'calc & store Eot, Decl, half-day-length values for yr
REM  EoT, Decl calculated for 1998 using Fer de Vries' method.
L8 = NR * 360 / 365.2422 - 80.535132#     'degrees
E1 = -107.0605 * SIN(L8 * D2R) - 428.6697 * COS(L8 * D2R)
E2 = 596.1009 * SIN(2 * L8 * D2R)
E3 = -2.0898 * COS(2 * L8 * D2R) + 4.4173 * SIN(3 * L8 * D2R)
E4 = 19.2776 * COS(3 * L8 * D2R) - 12.7338 * SIN(4 * L8 * D2R)
E = E1 + E2 + E3 + E4    'EoT in seconds of time
EoT(NR) = EoTyesno * (E / 60)    'EoT (in minutes) for this day, or zero
LAM1 = L8 + .4277 * SIN(D2R * L8) + 1.8664 * COS(D2R * L8)
LAM2 = -.0181 * SIN(D2R * 2 * L8) + .0087 * COS(D2R * 2 * L8)
LAMDA = LAM1 + LAM2     'degrees
D1 = SIN(LAMDA * D2R) * SIN(23.43954 * D2R)
DecSun = ATN(D1 / SQR(1 - D1 * D1)) * R2D     'declination of sun in degrees
Decl(NR) = DecSun      'store DecSun for this day
D2 = -TAN(PHI * D2R) * TAN(DecSun * D2R)
NEXT NR

X0 = 320: Y0 = 200     'screen coordinates of origin for dial's center

REM Screen and drawing plots may be scaled.  Normally, drX=drY; scX=scY.
drX = .01475: drY = .01475     'drawing scale opens near 1
scX = .25: scY = .25      'screen plot scale

FOR hour = -11 TO 11 STEP SPZ   'if SPZ=.5, draw half-hour lines
IF hour = INT(hour) THEN WRITE #1, 9, 65, 0   'whole hour curves in layer A
IF hour <> INT(hour) THEN WRITE #1, 9, 66, 0   'fractional hours in layer B
Day = M(STRT)
flag = 1
FOR J = 1 TO 366
IF J = 366 THEN Day = M(STRT)
HA = hour * 15 + (Loff + EoT(Day)) / 4   'std time hour angle of sun
A = ATN(SIN(PHI * D2R) * TAN(HA * D2R)) * R2D + (180 - b)
IF HA < -90 THEN A = A + 180
IF HA > 90 THEN A = A + 180
R = J + Min
Y = -R * COS(A * D2R): X = R * SIN(A * D2R)
IF Y < 0 THEN flag = 1: GOTO 115     'plot no points if sun below horizon
PSET (X * scX + X0, Y * scY + Y0), 0   'plot points on screen
REM Reverse the sign of Y values written to text file.
WRITE #1, flag, X * drX, -Y * drY    'write x,y to txt file
flag = 2                 'flag equals 1 for 1st point, 2 for others
115 Day = Day + 1: IF Day = 366 THEN Day = 1: 'flag = 1 (rem added 020801)
NEXT J
NEXT hour

WRITE #1, 9, 68, 0     'substyle line in layer D
A = 180 - b
R = Min * 2.05
X1 = R * SIN(A * D2R): Y1 = R * COS(A * D2R)
WRITE #1, 1, 0, 0
WRITE #1, 2, X1 * drX, Y1 * drY
LINE (0 * scX + X0, 0 * scY + Y0)-(X1 * scX + X0, -Y1 * scY + Y0), 0

WRITE #1, 9, 69, 0      'local solar noon line in layer E
WRITE #1, 1, 0, 0
WRITE #1, 2, 0, -R * drY
LINE (0 * scX + X0, 0 * scY + Y0)-(0 * scX + X0, R * scY + Y0), 0

WRITE #1, 9, 70, 0     'arcs in layer F
count = STRT: arc = 1
FOR J = 1 TO 13
Day = M(count)
IF J = 13 THEN arc = 366: Day = M(STRT)
R = arc + Min
WRITE #1, 3, -R * drX, 0
WRITE #1, 3, 0, 0
WRITE #1, 3, R * drX, 180
arc = arc + M4(count)
count = count + 1: IF count = 13 THEN count = 1
NEXT J
CLOSE #1
DATA "JAN",1,31,"FEB",32,28,"MAR",60,31,"APR",91,30
DATA "MAY",121,31,"JUN",152,30,"JUL",182,31,"AUG",213,31
DATA "SEP",244,30,"OCT",274,31,"NOV",305,30,"DEC",335,31
END



